         name      disktype
         page      55,132
         title     'DISKTYPE --- display diskette type'
;
; DISKTYPE utility to display the
; format type of selected diskette
;
; Ray Duncan,  Uncopyright (u) September 1983
; This program may be freely copied,
; mangled, enhanced, and redistributed.
;
input    equ       080h      ;command line tail buffer
cr       equ       0dh       ;ASCII carriage return
lf       equ       0ah       ;ASCII line feed
;
cseg     segment   para public 'CODE'
         assume    cs:cseg,ds:cseg,ss:stack
;
; This program becomes an EXE file.  On entry
; from PC-DOS, CS = address of entry point, IP = 0,
; SS = segment address of stack segment, DS and
; ES = segment address of Program Segment Prefix area.
;
disktype proc      far       ;entry point from PC-DOS
                             ;
         push      ds        ;put final return address
         xor       ax,ax     ;on stack (DS:0000)
         push      ax        ;for "Far Return" later.
                             ;DS=segment of program
                             ;prefix with command tail,
                             ;set SI=offset of command
                             ;tail's length byte,
         mov       si,offset input
         cld                 ;clear the Direction Flag
                             ;for "LODS" string instruction.
         lodsb               ;check length byte to see if
         or        al,al     ;there's any command tail.
         jz        disk2     ;no, use default drive.
                             ;
disk1:   lodsb               ;check the next byte of
                             ;the command tail,
         cmp       al,cr     ;if carriage return,
         je        disk2     ;use "default" disk drive.
         cmp       al,' '    ;if blank, keep scanning
         je        disk1     ;for another character.
         or        al,20h    ;fold the character to
                             ;lower case.
         cmp       al,'a'    ;make sure it's in range A-D
         jb        disk8     ;no, print error message
         cmp       al,'d'
         ja        disk8     ;no, print error message
         sub       al,'a'    ;make drive code 0-3
         jmp       short disk3
                             ;
disk2:                       ;if operator didn't specify
                             ;disk drive, get the "default
                             ;disk" from PC-DOS, returns
         mov       ah,19h    ;drive code in AL
         int       21h       ;(0=A, 1=B, etc.)
                             ;
disk3:   mov       bx,cs     ;now make DS and ES the
         mov       ds,bx     ;same as CS at entry
         mov       es,bx
         mov       dl,al     ;now put drive code in DL
         add       al,'a'    ;form ASCII character for
                             ;drive code and store it
         mov       diskc,al  ;into the output string.
         mov       dh,0      ;set head = 0 in DH,
         mov       ch,0      ;set track = 0 in CH,
         mov       cl,2      ;set sector = 2 in CL,
         mov       al,1      ;set number of sectors
                             ;to read into AL,
                             ;put address of data
                             ;buffer into BX,
         mov       bx,offset buffer
         mov       ah,2      ;AH=2 is read command,
                             ;now call ROM BIOS
         int       13H       ;to read first block of
                             ;File Allocation Table.
                             ;
         mov       bl,buffer ;pick up the first byte
                             ;of FAT (contains code for
                             ;disk format type) and
                             ;set SI = start of disk
                             ;type and message table.
         mov       si,offset diskk
disk4:   lodsb               ;get next type from table.
         or        al,al     ;if zero we didn't match
                             ;any valid type,
         jz        disk5     ;so go print "unknown".
         cmp       al,bl     ;check byte from table against
                             ;byte from diskette FAT sector.
         jz        disk5     ;got a match,jump.
         add       si,2      ;bump the table pointer
                             ;past the message address,
                             ;and check next table entry.
         jmp       short disk4
disk5:   mov       ah,9      ;print first part of message,
         mov       dx,offset diskb
         int       21h
         lodsw               ;pick up the message address
         mov       dx,ax     ;for this disk type, put into
         mov       ah,9      ;register DX, and print it.
         int       21h
                             ;print final carriage return
                             ;and line feed...
         mov       dx,offset diskj
         jmp       short disk9
                             ;come here if letter other
                             ;than A-D or a-d in command
disk8:                       ;line, print "invalid disk".
         push      cs        ;make DS = CS  so error
         pop       ds        ;message is addressable.
         mov       dx,offset diska
                             ;
disk9:   mov       ah,9      ;print message whose address
         int       21h       ;is in register DX, then
         ret                 ;"Far Return" to PC-DOS
;
disktype endp                ;end of procedure DISKTYPE
;
diska    db        cr,lf
         db        'Invalid disk code.  Use A, B, C or D.'
         db        cr,lf,'$'
diskb    db        cr,lf
         db        'The diskette in drive '
diskc    db        'x: is',cr,lf,'$'
diskd    db        '2 sided, 8 sectors per track.$'
diske    db        '1 sided, 8 sectors per track.$'
diskf    db        '2 sided, 9 sectors per track.$'
diskg    db        '1 sided, 9 sectors per track.$'
diskh    db        'fixed disk.$'
diski    db        'unknown to this program.$'
diskj    db        cr,lf,'$'
;
; "diskk" is a table in which the byte
; signifying a disk format is followed
; by the address of a descriptive message
;
diskk    db        0ffh      ;2 sides 8 sectors
         dw        diskd
         db        0feh      ;1 side 8 sectors
         dw        diske
         db        0fdh      ;2 sides 9 sectors
         dw        diskf
         db        0fch      ;1 side 9 sectors
         dw        diskg
         db        0f8h      ;fixed disk
         dw        diskh
         db        0         ;unknown,end of table
         dw        diski
;
buffer   db        512 dup (?)
;
cseg     ends
;
stack    segment   para stack 'STACK'
         db        64 dup (?)
stack    ends
;
         end       disktype
